/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class BlockEntityRedstoneImpetus
extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";
    public static final String TAG_STORED_PLAYER_PROFILE = "stored_player_profile";
    private GameProfile storedPlayerProfile = null;
    private UUID storedPlayer = null;
    private GameProfile cachedDisplayProfile = null;
    private class_1799 cachedDisplayStack = null;

    public BlockEntityRedstoneImpetus(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.IMPETUS_REDSTONE_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    protected GameProfile getPlayerName() {
        class_3222 player;
        if (this.field_11863 instanceof class_3218 && (player = this.getStoredPlayer()) != null) {
            return player.method_7334();
        }
        return this.storedPlayerProfile;
    }

    public void setPlayer(GameProfile profile, UUID player) {
        this.storedPlayerProfile = profile;
        this.storedPlayer = player;
        this.method_5431();
    }

    public void clearPlayer() {
        this.storedPlayerProfile = null;
        this.storedPlayer = null;
    }

    public void updatePlayerProfile() {
        GameProfile newProfile;
        class_3222 player = this.getStoredPlayer();
        if (player != null && !(newProfile = player.method_7334()).equals((Object)this.storedPlayerProfile)) {
            this.storedPlayerProfile = newProfile;
            this.method_5431();
        }
    }

    @Nullable
    public class_3222 getStoredPlayer() {
        if (this.storedPlayer == null) {
            return null;
        }
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            HexAPI.LOGGER.error("Called getStoredPlayer on the client");
            return null;
        }
        class_3218 slevel = (class_3218)class_19372;
        class_1297 e = slevel.method_14190(this.storedPlayer);
        if (e instanceof class_3222) {
            class_3222 player = (class_3222)e;
            return player;
        }
        if (e != null) {
            HexAPI.LOGGER.error("Entity {} stored in a cleric impetus wasn't a player somehow", (Object)e);
        }
        return null;
    }

    @Override
    public void applyScryingLensOverlay(List<Pair<class_1799, class_2561>> lines, class_2680 state, class_2338 pos, class_1657 observer, class_1937 world, class_2350 hitFace) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace);
        GameProfile name = this.getPlayerName();
        if (name != null) {
            if (!name.equals((Object)this.cachedDisplayProfile) || this.cachedDisplayStack == null) {
                this.cachedDisplayProfile = name;
                class_1799 head = new class_1799((class_1935)class_1802.field_8575);
                NBTHelper.put(head, "SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)name));
                head.method_7909().method_7860(head.method_7948());
                this.cachedDisplayStack = head;
            }
            lines.add((Pair<class_1799, class_2561>)new Pair((Object)this.cachedDisplayStack, (Object)class_2561.method_43469((String)"hexcasting.tooltip.lens.impetus.redstone.bound", (Object[])new Object[]{name.getName()})));
        } else {
            lines.add((Pair<class_1799, class_2561>)new Pair((Object)new class_1799((class_1935)class_1802.field_8077), (Object)class_2561.method_43471((String)"hexcasting.tooltip.lens.impetus.redstone.bound.none")));
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.method_25927(TAG_STORED_PLAYER, this.storedPlayer);
        }
        if (this.storedPlayerProfile != null) {
            tag.method_10566(TAG_STORED_PLAYER_PROFILE, (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.storedPlayerProfile));
        }
    }

    @Override
    protected void loadModData(class_2487 tag) {
        super.loadModData(tag);
        this.storedPlayer = tag.method_10573(TAG_STORED_PLAYER, 11) ? tag.method_25926(TAG_STORED_PLAYER) : null;
        this.storedPlayerProfile = tag.method_10573(TAG_STORED_PLAYER_PROFILE, 10) ? class_2512.method_10683((class_2487)tag.method_10562(TAG_STORED_PLAYER_PROFILE)) : null;
    }
}

